-- Predependencies:
-- 1. Temp table EPL_NDCS_TEMP_SIZES created containing the NDC Id and package size value
-- 2. Script that changed NDC package size from VARCHAR to FK (first half of NDC_4_ALTER_NDC_TABLE_AND_UPDATE.sql)
-- 3. Package Size Migration run via PPS-N UI
-- 4. Reset IENs script 
-- This script will:
-- * identify NDCs with package size values that do not have a corresponding package size loaded in the migration
-- * create package size records for those missing package sizes
-- * insert outgoing difference records for the added package sizes 
-- * update the ien generator to make sure the package size ien accounts for these new records.
-- 
-- Post Dependencies: 
-- * Update NDC table to populate the package size FKs (second half of NDC_4_ALTER_NDC_TABLE_AND_UPDATE.sql)
-- * Drop the ppsnepl.temp_epl_ndcs table

DECLARE
  l_ien  epl_ien_generator.last_used_ien%TYPE;
  l_package_size ppsnepl.temp_epl_ndcs.package_size%TYPE;
  
  CURSOR new_package_sizes_cursor
     IS
    SELECT distinct(ndcs_old.package_size) from ppsnepl.temp_epl_ndcs ndcs_old where not exists (select 1 from epl_package_sizes ps where ps.package_size = ndcs_old.package_size);
BEGIN
   SELECT last_used_ien
     INTO l_ien
     FROM epl_ien_generator
    WHERE concept = 'EPL_PACKAGE_SIZES';

   OPEN new_package_sizes_cursor;

   LOOP
      FETCH new_package_sizes_cursor INTO l_package_size;

      EXIT WHEN new_package_sizes_cursor%NOTFOUND;

      l_ien := l_ien + 1;

      INSERT INTO epl_package_sizes (CREATED_BY,
                                     CREATED_DTM,
                                     EPL_ID,
                                     LAST_MODIFIED_BY,
                                     LAST_MODIFIED_DTM,
                                     NDF_PACKAGE_SIZE_IEN,
                                     PACKAGE_SIZE)
           VALUES ('MIGRATION',
                   SYSDATE,
                   EPL_PACKAGE_SIZES_SEQ.NEXTVAL,
                   'MIGRATION',
                   SYSDATE,
                   l_ien,
                   l_package_size);

      INSERT INTO EPL_NDF_OUTGOING_DIFFERENCES (ACTION_TYPE,
                                                CREATED_BY,
                                                CREATED_DTM,
                                                NDC_UPDATE_FILE_FK,
                                                NDF_OUTGOING_DIFFERENCES_ID,
                                                NEW_VALUE,
                                                OLD_VALUE,
                                                VISTA_FIELD_NUMBER,
                                                VISTA_FILE_NUMBER,
                                                VISTA_IEN)
           VALUES ('A',
                   'MIGRATION',
                   SYSDATE,
                   NULL,
                   EPL_NDF_OUTGOING_DIFFERENS_SEQ.NEXTVAL,
                   l_package_size,
                   NULL,
                   '.01',
                   '50.609',
                   l_ien);
   END LOOP;

   UPDATE epl_ien_generator
      SET last_used_ien = l_ien
    WHERE concept = 'EPL_PACKAGE_SIZES';

   CLOSE new_package_sizes_cursor;
END;

COMMIT;